Macedonian and Bulgarian (`apertium-mkd-bul`)
===============================================================================

This is an Apertium language pair for translating between Macedonian and 
Bulgarian. What you can use this language package for:

* Translating between Macedonian and Bulgarian
* Morphological analysis of Macedonian and Bulgarian
* Part-of-speech tagging of Macedonian and Bulgarian

For information on the latter two points, see subheading "For more 
information" below

Requirements
===============================================================================

You will need the following software installed:

* lttoolbox (>= 3.1.2)
* apertium (>= 3.1.1)
* vislcg3 (>= 0.9.7.5129)

If this does not make any sense, we recommend you look at: www.apertium.org

Compiling
===============================================================================

Given the requirements being installed, you should be able to just run:
```
$ ./configure 
$ make
```
You can use `./autogen.sh` instead of `./configure` you're compiling from
git. If you're using a `--prefix` to `./configure`, make sure it's the
same one you used to install apertium itself.

Testing
===============================================================================

If you are in the source directory after running make, the following
commands should work:
```
$  echo "Јас сум тука." | apertium -d . mkd-bul
Аз съм тук.
```
After installing somewhere in $PATH, you should be able to do eg.
```
$  echo "Јас сум тука." | apertium mkd-bul
Аз съм тук.
```
The following command runs tests which are on the Apertium wiki page:
```
$ ./regression-tests.sh 
```

Files and data
===============================================================================

* `apertium-mkd-bul.mkd.dix`            - Monolingual dictionary for Macedonian
* `apertium-mkd-bul.post-mkd.dix`       - Postgeneration dictionary for Macedonian
* `apertium-mkd-bul.mkd-bul.dix`        - Bilingual dictionary 
* `apertium-mkd-bul.bul.dix`            - Monolingual dictionary for Bulgarian
* `apertium-mkd-bul.post-bul.dix`       - Postgeneration dictionary for Bulgarian
* `apertium-mkd-bul.mkd-bul.rlx`        - Constraint Grammar for Macedonian
* `apertium-mkd-bul.mkd-bul.t1x`        - Chunker rules for translating into Bulgarian
* `apertium-mkd-bul.bul-mkd.t1x`        - Chunker rules for translating into Macedonian
* `mkd-bul.prob`                        - Tagger model for Macedonian
* `bul-mkd.prob`                        - Tagger model for Bulgarian
* `modes.xml`                           - Translation modes

For more information
===============================================================================

* http://wiki.apertium.org/wiki/Installation
* http://wiki.apertium.org/wiki/apertium-mkd-bul
* http://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary
* http://wiki.apertium.org/wiki/Constraint_Grammar

Help and support
===============================================================================

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: `#apertium` on `irc.freenode.net`

See also the file AUTHORS included in this distribution.
