# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath(os.path.join('..', '..')))


# -- Project information -----------------------------------------------------

project = 'awscrt'
copyright = '2020, Amazon Web Services, Inc'
author = 'Amazon Web Services, Inc'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.napoleon',
    'sphinx.ext.intersphinx', # for linking external docs (official Python API)
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# 'bysource' prevents enums from sorting in alphabetical order
autodoc_member_order = 'bysource'

# False puts type in the "Returns: " line, rather than its own "Return Type:" line.
# without this, we ge a lot of empty "Returns:" lines because we only commented the type.
napoleon_use_rtype = False

# A string that determines how domain objects (e.g. functions, classes, 
# attributes, etc.) are displayed in their table of contents entry.
toc_object_entries_show_parents = 'hide'

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'bizstyle'

html_theme_options = {
    'sidebarwidth': 300
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_style = 'css/custom.css'

# For cross-linking to types from other libraries
intersphinx_mapping = {
    'python': ('https://docs.python.org/3', None),
}

# Extra warnings
nitpicky = True
