/* Ergo, version 3.8.2, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2023 Elias Rudberg, Emanuel H. Rubensson, Pawel Salek,
 * and Anastasia Kruchinina.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Ergo: An open-source program for linear-scaling electronic structure
 * calculations,
 * Elias Rudberg, Emanuel H. Rubensson, Pawel Salek, and Anastasia
 * Kruchinina,
 * SoftwareX 7, 107 (2018),
 * <http://dx.doi.org/10.1016/j.softx.2018.03.005>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */

/** @file densfromf_full.h

    @brief Routine get_dens_from_fock_full() for getting density
    matrix from a given Fock matrix using diagonalization.

    @author: Elias Rudberg <em>responsible</em>
*/

#ifndef DENSFROMFFULLHEADER
#define DENSFROMFFULLHEADER

#include <vector>
#include "realtype.h"

int get_F_orbs(int n, 
	       const ergo_real* F, 
	       const ergo_real* ovl, 
	       ergo_real* cmo, 
	       ergo_real* eigv);

int get_dens_from_fock_full(int n, 
			    int noOfOccupiedOrbs, 
			    ergo_real* result_P, 
			    const ergo_real* F, 
			    const ergo_real* ovl, 
			    ergo_real factor,
			    ergo_real electronicTemperature,
			    ergo_real & resultEntropyTerm,
			    ergo_real & resultHomoLumoGap,
			    int store_all_eigenvalues_to_file, 
					int number_of_occ_eigenvectors, 
					int number_of_unocc_eigenvectors, 
					std::vector<std::vector<ergo_real> > &eigVecOCC, 
					std::vector<std::vector<ergo_real> > &eigVecUNOCC,
					std::vector<ergo_real> &eigValOCC, 
					std::vector<ergo_real> &eigValUNOCC );

#endif
