//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdns

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type RecordSet.
func (r RecordSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecordSetProperties.
func (r RecordSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ARecords", r.ARecords)
	populate(objectMap, "AAAARecords", r.AaaaRecords)
	populate(objectMap, "caaRecords", r.CaaRecords)
	populate(objectMap, "CNAMERecord", r.CnameRecord)
	populate(objectMap, "fqdn", r.Fqdn)
	populate(objectMap, "metadata", r.Metadata)
	populate(objectMap, "MXRecords", r.MxRecords)
	populate(objectMap, "NSRecords", r.NsRecords)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "PTRRecords", r.PtrRecords)
	populate(objectMap, "SOARecord", r.SoaRecord)
	populate(objectMap, "SRVRecords", r.SrvRecords)
	populate(objectMap, "TTL", r.TTL)
	populate(objectMap, "targetResource", r.TargetResource)
	populate(objectMap, "TXTRecords", r.TxtRecords)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceReferenceRequestProperties.
func (r ResourceReferenceRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "targetResources", r.TargetResources)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TxtRecord.
func (t TxtRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Zone.
func (z Zone) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", z.Etag)
	populate(objectMap, "id", z.ID)
	populate(objectMap, "location", z.Location)
	populate(objectMap, "name", z.Name)
	populate(objectMap, "properties", z.Properties)
	populate(objectMap, "tags", z.Tags)
	populate(objectMap, "type", z.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ZoneProperties.
func (z ZoneProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "maxNumberOfRecordSets", z.MaxNumberOfRecordSets)
	populate(objectMap, "maxNumberOfRecordsPerRecordSet", z.MaxNumberOfRecordsPerRecordSet)
	populate(objectMap, "nameServers", z.NameServers)
	populate(objectMap, "numberOfRecordSets", z.NumberOfRecordSets)
	populate(objectMap, "registrationVirtualNetworks", z.RegistrationVirtualNetworks)
	populate(objectMap, "resolutionVirtualNetworks", z.ResolutionVirtualNetworks)
	populate(objectMap, "zoneType", z.ZoneType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ZoneUpdate.
func (z ZoneUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", z.Tags)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}
