//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armelasticsan

import "time"

// ElasticSan - Response for ElasticSan request.
type ElasticSan struct {
	// REQUIRED; Properties of ElasticSan.
	Properties *Properties `json:"properties,omitempty"`

	// The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`

	// Azure resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource metadata required by ARM RPC
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ElasticSansClientBeginCreateOptions contains the optional parameters for the ElasticSansClient.BeginCreate method.
type ElasticSansClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ElasticSansClientBeginDeleteOptions contains the optional parameters for the ElasticSansClient.BeginDelete method.
type ElasticSansClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ElasticSansClientBeginUpdateOptions contains the optional parameters for the ElasticSansClient.BeginUpdate method.
type ElasticSansClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ElasticSansClientGetOptions contains the optional parameters for the ElasticSansClient.Get method.
type ElasticSansClientGetOptions struct {
	// placeholder for future optional parameters
}

// ElasticSansClientListByResourceGroupOptions contains the optional parameters for the ElasticSansClient.ListByResourceGroup
// method.
type ElasticSansClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ElasticSansClientListBySubscriptionOptions contains the optional parameters for the ElasticSansClient.ListBySubscription
// method.
type ElasticSansClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// IscsiTargetInfo - Iscsi target information
type IscsiTargetInfo struct {
	// Operational status of the iSCSI Target.
	Status *OperationalStatus `json:"status,omitempty"`

	// READ-ONLY; State of the operation on the resource.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
	TargetIqn *string `json:"targetIqn,omitempty" azure:"ro"`

	// READ-ONLY; iSCSI Target Portal Host Name
	TargetPortalHostname *string `json:"targetPortalHostname,omitempty" azure:"ro"`

	// READ-ONLY; iSCSI Target Portal Port
	TargetPortalPort *int32 `json:"targetPortalPort,omitempty" azure:"ro"`
}

// List of Elastic Sans
type List struct {
	// REQUIRED; An array of Elastic San objects.
	Value []*ElasticSan `json:"value,omitempty"`

	// READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// NetworkRuleSet - A set of rules governing the network accessibility.
type NetworkRuleSet struct {
	// The list of virtual network rules.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// OperationDisplay - Metadata about an operation.
type OperationDisplay struct {
	// REQUIRED; Localized friendly description for the operation, as it should be shown to the user.
	Description *string `json:"description,omitempty"`

	// REQUIRED; Localized friendly name for the operation, as it should be shown to the user.
	Operation *string `json:"operation,omitempty"`

	// REQUIRED; Localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`

	// REQUIRED; Localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - List of operations supported by the RP.
type OperationListResult struct {
	// REQUIRED; An array of operations supported by the ElasticSan RP.
	Value []*RPOperation `json:"value,omitempty"`

	// URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Properties - Elastic San response properties.
type Properties struct {
	// REQUIRED; Base size of the Elastic San appliance in TiB.
	BaseSizeTiB *int64 `json:"baseSizeTiB,omitempty"`

	// REQUIRED; Extended size of the Elastic San appliance in TiB.
	ExtendedCapacitySizeTiB *int64 `json:"extendedCapacitySizeTiB,omitempty"`

	// REQUIRED; resource sku
	SKU *SKU `json:"sku,omitempty"`

	// Logical zone for Elastic San resource; example: ["1"].
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// READ-ONLY; State of the operation on the resource.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Total Provisioned IOPS of the Elastic San appliance.
	TotalIops *int64 `json:"totalIops,omitempty" azure:"ro"`

	// READ-ONLY; Total Provisioned MBps Elastic San appliance.
	TotalMBps *int64 `json:"totalMBps,omitempty" azure:"ro"`

	// READ-ONLY; Total size of the Elastic San appliance in TB.
	TotalSizeTiB *int64 `json:"totalSizeTiB,omitempty" azure:"ro"`

	// READ-ONLY; Total size of the provisioned Volumes in GiB.
	TotalVolumeSizeGiB *int64 `json:"totalVolumeSizeGiB,omitempty" azure:"ro"`

	// READ-ONLY; Total number of volume groups in this Elastic San appliance.
	VolumeGroupCount *int64 `json:"volumeGroupCount,omitempty" azure:"ro"`
}

// RPOperation - Description of a ElasticSan RP Operation
type RPOperation struct {
	// REQUIRED; The name of the operation being performed on this particular object
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Additional metadata about RP operation.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`
}

// SKU - The SKU name. Required for account creation; optional for update.
type SKU struct {
	// REQUIRED; The sku name.
	Name *SKUName `json:"name,omitempty"`

	// The sku tier.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SKUCapability - The capability information in the specified SKU.
type SKUCapability struct {
	// READ-ONLY; The name of capability.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; A string value to indicate states of given capability.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// SKUInformation - ElasticSAN SKU and its properties
type SKUInformation struct {
	// REQUIRED; Sku Name
	Name *SKUName `json:"name,omitempty"`

	// Sku Tier
	Tier *SKUTier `json:"tier,omitempty"`

	// READ-ONLY; The capability information in the specified SKU.
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Availability of the SKU for the location/zone
	LocationInfo []*SKULocationInfo `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g.
	// West US, East US, Southeast Asia, etc.).
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`
}

// SKUInformationList - List of SKU Information objects
type SKUInformationList struct {
	// READ-ONLY; List of ResourceType Sku
	Value []*SKUInformation `json:"value,omitempty" azure:"ro"`
}

// SKULocationInfo - The location info.
type SKULocationInfo struct {
	// READ-ONLY; The location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The zones.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.List method.
type SKUsClientListOptions struct {
	// Specify $filter='location eq ' to filter on location.
	Filter *string
}

// SourceCreationData - Data source used when creating the volume.
type SourceCreationData struct {
	// This enumerates the possible sources of a volume creation.
	CreateSource *string `json:"createSource,omitempty"`

	// If createOption is Copy, this is the ARM id of the source snapshot or disk. If createOption is Restore, this is the ARM-like
	// id of the source disk restore point.
	SourceURI *string `json:"sourceUri,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// Update - Response for ElasticSan update request.
type Update struct {
	// Properties of ElasticSan.
	Properties *UpdateProperties `json:"properties,omitempty"`

	// Update tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// UpdateProperties - Elastic San update properties.
type UpdateProperties struct {
	// Base size of the Elastic San appliance in TiB.
	BaseSizeTiB *int64 `json:"baseSizeTiB,omitempty"`

	// Extended size of the Elastic San appliance in TiB.
	ExtendedCapacitySizeTiB *int64 `json:"extendedCapacitySizeTiB,omitempty"`
}

// VirtualNetworkRule - Virtual Network rule.
type VirtualNetworkRule struct {
	// REQUIRED; Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`

	// The action of virtual network rule.
	Action *string `json:"action,omitempty"`

	// READ-ONLY; Gets the state of virtual network rule.
	State *State `json:"state,omitempty" azure:"ro"`
}

// Volume - Response for Volume request.
type Volume struct {
	// Properties of Volume.
	Properties *VolumeProperties `json:"properties,omitempty"`

	// Azure resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource metadata required by ARM RPC
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeGroup - Response for Volume Group request.
type VolumeGroup struct {
	// Properties of VolumeGroup.
	Properties *VolumeGroupProperties `json:"properties,omitempty"`

	// Azure resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource metadata required by ARM RPC
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VolumeGroupList - List of Volume Groups
type VolumeGroupList struct {
	// REQUIRED; An array of Volume Groups objects.
	Value []*VolumeGroup `json:"value,omitempty"`

	// READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VolumeGroupProperties - VolumeGroup response properties.
type VolumeGroupProperties struct {
	// Type of encryption
	Encryption *EncryptionType `json:"encryption,omitempty"`

	// A collection of rules governing the accessibility from specific network locations.
	NetworkACLs *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Type of storage target
	ProtocolType *StorageTargetType `json:"protocolType,omitempty"`

	// READ-ONLY; State of the operation on the resource.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`
}

// VolumeGroupUpdate - Volume Group request.
type VolumeGroupUpdate struct {
	// Properties of VolumeGroup.
	Properties *VolumeGroupUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VolumeGroupUpdateProperties - VolumeGroup response properties.
type VolumeGroupUpdateProperties struct {
	// Type of encryption
	Encryption *EncryptionType `json:"encryption,omitempty"`

	// A collection of rules governing the accessibility from specific network locations.
	NetworkACLs *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Type of storage target
	ProtocolType *StorageTargetType `json:"protocolType,omitempty"`
}

// VolumeGroupsClientBeginCreateOptions contains the optional parameters for the VolumeGroupsClient.BeginCreate method.
type VolumeGroupsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeGroupsClientBeginDeleteOptions contains the optional parameters for the VolumeGroupsClient.BeginDelete method.
type VolumeGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeGroupsClientBeginUpdateOptions contains the optional parameters for the VolumeGroupsClient.BeginUpdate method.
type VolumeGroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumeGroupsClientGetOptions contains the optional parameters for the VolumeGroupsClient.Get method.
type VolumeGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumeGroupsClientListByElasticSanOptions contains the optional parameters for the VolumeGroupsClient.ListByElasticSan
// method.
type VolumeGroupsClientListByElasticSanOptions struct {
	// placeholder for future optional parameters
}

// VolumeList - List of Volumes
type VolumeList struct {
	// REQUIRED; An array of Volume objects.
	Value []*Volume `json:"value,omitempty"`

	// READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VolumeProperties - Volume response properties.
type VolumeProperties struct {
	// State of the operation on the resource.
	CreationData *SourceCreationData `json:"creationData,omitempty"`

	// Volume size.
	SizeGiB *int64 `json:"sizeGiB,omitempty"`

	// READ-ONLY; Storage target information
	StorageTarget *IscsiTargetInfo `json:"storageTarget,omitempty" azure:"ro"`

	// READ-ONLY; Unique Id of the volume in GUID format
	VolumeID *string `json:"volumeId,omitempty" azure:"ro"`
}

// VolumeUpdate - Response for Volume request.
type VolumeUpdate struct {
	// Properties of Volume.
	Properties *VolumeUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VolumeUpdateProperties - Volume response properties.
type VolumeUpdateProperties struct {
	// Volume size.
	SizeGiB *int64 `json:"sizeGiB,omitempty"`
}

// VolumesClientBeginCreateOptions contains the optional parameters for the VolumesClient.BeginCreate method.
type VolumesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginDeleteOptions contains the optional parameters for the VolumesClient.BeginDelete method.
type VolumesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientBeginUpdateOptions contains the optional parameters for the VolumesClient.BeginUpdate method.
type VolumesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VolumesClientGetOptions contains the optional parameters for the VolumesClient.Get method.
type VolumesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumesClientListByVolumeGroupOptions contains the optional parameters for the VolumesClient.ListByVolumeGroup method.
type VolumesClientListByVolumeGroupOptions struct {
	// placeholder for future optional parameters
}
