// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilAssetActive uses the AWS IoT SiteWise API operation
// DescribeAsset to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *IoTSiteWise) WaitUntilAssetActive(input *DescribeAssetInput) error {
	return c.WaitUntilAssetActiveWithContext(aws.BackgroundContext(), input)
}

// WaitUntilAssetActiveWithContext is an extended version of WaitUntilAssetActive.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) WaitUntilAssetActiveWithContext(ctx aws.Context, input *DescribeAssetInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilAssetActive",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "assetStatus.state",
				Expected: "ACTIVE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "assetStatus.state",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeAssetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAssetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilAssetModelActive uses the AWS IoT SiteWise API operation
// DescribeAssetModel to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *IoTSiteWise) WaitUntilAssetModelActive(input *DescribeAssetModelInput) error {
	return c.WaitUntilAssetModelActiveWithContext(aws.BackgroundContext(), input)
}

// WaitUntilAssetModelActiveWithContext is an extended version of WaitUntilAssetModelActive.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) WaitUntilAssetModelActiveWithContext(ctx aws.Context, input *DescribeAssetModelInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilAssetModelActive",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "assetModelStatus.state",
				Expected: "ACTIVE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "assetModelStatus.state",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeAssetModelInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAssetModelRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilAssetModelNotExists uses the AWS IoT SiteWise API operation
// DescribeAssetModel to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *IoTSiteWise) WaitUntilAssetModelNotExists(input *DescribeAssetModelInput) error {
	return c.WaitUntilAssetModelNotExistsWithContext(aws.BackgroundContext(), input)
}

// WaitUntilAssetModelNotExistsWithContext is an extended version of WaitUntilAssetModelNotExists.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) WaitUntilAssetModelNotExistsWithContext(ctx aws.Context, input *DescribeAssetModelInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilAssetModelNotExists",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeAssetModelInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAssetModelRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilAssetNotExists uses the AWS IoT SiteWise API operation
// DescribeAsset to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *IoTSiteWise) WaitUntilAssetNotExists(input *DescribeAssetInput) error {
	return c.WaitUntilAssetNotExistsWithContext(aws.BackgroundContext(), input)
}

// WaitUntilAssetNotExistsWithContext is an extended version of WaitUntilAssetNotExists.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) WaitUntilAssetNotExistsWithContext(ctx aws.Context, input *DescribeAssetInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilAssetNotExists",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeAssetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAssetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilPortalActive uses the AWS IoT SiteWise API operation
// DescribePortal to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *IoTSiteWise) WaitUntilPortalActive(input *DescribePortalInput) error {
	return c.WaitUntilPortalActiveWithContext(aws.BackgroundContext(), input)
}

// WaitUntilPortalActiveWithContext is an extended version of WaitUntilPortalActive.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) WaitUntilPortalActiveWithContext(ctx aws.Context, input *DescribePortalInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilPortalActive",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "portalStatus.state",
				Expected: "ACTIVE",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribePortalInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePortalRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilPortalNotExists uses the AWS IoT SiteWise API operation
// DescribePortal to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *IoTSiteWise) WaitUntilPortalNotExists(input *DescribePortalInput) error {
	return c.WaitUntilPortalNotExistsWithContext(aws.BackgroundContext(), input)
}

// WaitUntilPortalNotExistsWithContext is an extended version of WaitUntilPortalNotExists.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) WaitUntilPortalNotExistsWithContext(ctx aws.Context, input *DescribePortalInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilPortalNotExists",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribePortalInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePortalRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
