#!/bin/sh -e
# Copyright (c) 2002-2019 Martin A. Godisch <martin@godisch.de>

test -e wmweather.c
umask 022
autoheader -Wall
autoconf -Wall
./configure
make distclean
rm -rf autom4te.cache
rm -f autoscan.log configure.scan
cd ..
chmod -R go=u-w .
version="`pwd`"
version="${version##*-}"
fakeroot debian/rules clean
cd ..
tar cvzf wmweather-$version.tar.gz --exclude CVS --exclude .cvsignore --exclude .hg --exclude .hgignore --exclude debian --exclude .pc wmweather-$version
ln -sf wmweather-$version.tar.gz wmweather_$version.orig.tar.gz
